import string









"""




Generate scans and calibrate commands from a list of reflections.









Here we need to do the hard work of checking to see if scans need to be merged




together due to overlap between the scan ranges.









We'll use a criterion that if they are within 2 degrees of each other, they should




be merged.









"""




def genscans(peaklist, scandir, titletext):




    listofscans=[]




    ival=0




    while 1:




        if ival > len(peaklist)-1:




            break




        else:




            if ival+1 > len(peaklist)-1:




                ival=ival+1




            else:




                currmax=abs(peaklist[ival][2])




                nextmin=abs(peaklist[ival+1][1])




                # In this location we join together peaks if their start/stop are within 2 degrees




                # of each other




                if (abs(nextmin-currmax) < 0.2) | (abs(nextmin) <= abs(currmax)):




                #if (abs(nextmin-currmax) < 2.0):




                    hnext=peaklist[ival+1][0][0]




                    knext=peaklist[ival+1][0][1]




                    lnext=peaklist[ival+1][0][2]




                    peaklist[ival][0].append(hnext)




                    peaklist[ival][0].append(knext)




                    peaklist[ival][0].append(lnext)




                    peaklist[ival][1]=peaklist[ival][1]




                    peaklist[ival][2]=peaklist[ival+1][2]




                    peaklist.pop(ival+1)




                else:




                    ival=ival+1









    commands=[]




    




    for items in peaklist:




        if len(items[0]) == 3:




            # Only one peak included




            hklstring=string.join([str(x) for x in items[0]])




            hklscan=string.join([str(x) for x in items[0]],',')




            scantitle='scantitle "%s (%s)"' % (titletext,hklscan)




            commands.append(scantitle)




            s2range=abs(items[1]-items[2])




            s2step=s2range/40




            if scandir > 0:




                scanstring="scan s2 %f %f %f" % (items[1], items[2], s2step)




            else:




                scanstring="scan s2 %f %f %f" % (items[2], items[1], s2step)




            commands.append(scanstring)




            




            calstring= "calibrate fit indices %s" % (hklstring)




            commands.append(calstring)




        else:




            npeaks=len(items[0])/3




            hkltext=""




            # The [:] in the next line makes a 'REAL' copy




            # of the variable as opposed to a reference




            indices1=items[0][:]




            for i in range(npeaks):




                hklscan="("+string.join([str(x) for x in indices1[:3]],',')+") "




                hkltext=hkltext+hklscan




                # Remove the first three items




                del indices1[:3]




            scantitle='scantitle "%s %s"' % (titletext,hkltext)




            commands.append(scantitle)




            hklstring=string.join([str(x) for x in items[0]])




            s2range=abs(items[1]-items[2])




            s2step=s2range/(40.0*npeaks)




            if scandir > 0:




                scanstring="scan s2 %f %f %f" % (items[1], items[2], s2step)




            else:




                scanstring="scan s2 %f %f %f" % (items[2], items[1], s2step)




            commands.append(scanstring)




            icount=1




            indices2=items[0][:]




            for i in range(npeaks):




                hklstring=string.join([str(x) for x in indices2[:3]])




                # Remove the first three items




                del indices2[:3]




                calstring=("calibrate fit indices %s npeaks=%d peakstore=%d" % (hklstring, npeaks, icount))




                commands.append(calstring)




                icount=icount+1




        




      




    return commands




        




